	'use strict';
	
	var Blockly;
	var flag = true;//判断计算器面板输入框是否覆盖输入框中的值

	function Numpad(val,x,y)
	{
		var self = this;
		this.display = $(".numpad_display");
		this.value = "";

		this.stack = null;
		this.stackOp = null;
		this.clearStack = true;

		position(x,y);
		self.setDefVal(val);		

		$("span").on('click', function() 
		{
			var code = $(this).text().trim();
			if(code == MSG['numpad_clear']) 
			{
				self.clear();
			} 
			else if(code == "-")
			{
				self.zf();
			} 
			else if(code == ".")
			{
				self.dot();
			} 
			else if(code == MSG['numpad_delete'])
			{
				self.backSpace();
			} 
			else if(code == MSG['numpad_enter'])
			{
				flag = true;
			} 
			else if(!isNaN(code))
			{
				if(flag == true)
				{
					self.clear();
					self.num(code);
					flag = false;
				}
				else if(flag == false)
				{
					self.num(code);
				}
			}
			else
			{

			}
			
			return;
		});



		$(".equal").on('click', function()
		{
			self.equalVal = self.display.val()
			if(isNaN(Number(self.equalVal)))
			{
				self.equalVal = "";
				self.onExit();
				return;
			}
			if(self.equalVal == "")
			{
				self.onExit();
				return;
			}
			self.equalVal = Number(self.equalVal);
			self.onEqual(self.equalVal);
		});

		$(".numpad_bg").on('click', function()
		{
			//self.onExit();
		});

		$(".subclose").on('click', function()
		{
			self.onExit();
		});
		
	}


	Numpad.prototype = 
	{
		setDefVal: function(val)
		{
			if(typeof val !== "string")
			{
				String(val);
			}
			this.value = val;
			this.save();
		},
		dot: function()
		{
			if(this.value.indexOf(".") == -1)
			{
				this.num(".");
			}
		},
		num: function(d)
		{
			this.value += d;
			this.save();
		},
		zf: function()
		{
			if(this.value.indexOf("-") == -1)
			{
				this.value = "-" + this.value;
			}
			else
			{
				this.value = this.value.substr(1, this.value.length);
			}
			this.save();
		},
		backSpace: function()
		{
			this.value = this.value.substr(0, this.value.length-1);
			this.save();
		},
		clear: function()
		{
			this.value = "";
			this.save();
		},
		onEqual: function(val){},
		onExit: function(){},
		load: function() 
		{
			return this.display.val() || this.display.text();
		},
		save: function() 
		{			
			if (this.display.is("input")) 
			{
				this.display.val(this.value);
			} 
			else 
			{
				this.display.text(this.value);
			}
		},
		get v() 
		{
			return this.value;
		},
		set v(val) 
		{
			this.clearStack = false;
			this.value = val;
			this.save();
		},
		get op() 
		{
			return this.stackOp;
		},
		set op(value) 
		{
			switch (this.stackOp) 
			{
				case "+":
					this.v = this.stack + this.v;
					break;
				case "-":
					this.v = this.stack - this.v;
					break;
				case "x":
					this.v = this.stack * this.v;
					break;
				case "/":
					this.v = this.stack / this.v;
					break;
			}
			this.stack = this.v;
			this.stackOp = value;
			this.clearStack = true;
		},
		set digit(d) 
		{
			d = parseInt(d);
			if (this.clearStack) return this.v = d;
			return this.v = this.v * 10 + d;
		},
		get digit() 
		{
			if (this.clearStack) return this.v = 0;
			return this.v = Math.floor(this.v / 10);
		}
	};

	function create(val,x,y)
	{
		

		var template =
			'<div class="numpad">' +
			'<div class="numpad_bg"></div>' +			

			'<div class="numpad_wrap" id="id_numpad_wrap">' +
			'<input class="numpad_display" type="text" placeholder="0" />' +

			'<div class="subclose">' +
			'<img src="media/close.png" width="35px" height="35px">' +
			'</div>' +

			'<div class="numpad_key">' +
			'<span>7</span>' +
			'<span>8</span>' +
			'<span>9</span>' +
			'<span>-</span>' +
			'<span class="clear operation">' + MSG['numpad_clear'] + '</span><br>' + 

			'<span>4</span>' +
			'<span>5</span>' +
			'<span>6</span>' +
			'<span>0</span>' +
			'<span>' + MSG['numpad_delete'] + '</span><br>' + 

			'<span>1</span>' +
			'<span>2</span>' +
			'<span>3</span>' +
			'<span>.</span>' +
			'<span class="equal operation">' + MSG['numpad_enter'] + '</span>' +
			'</div>' +
			'</div>' +
			'</div>';

		$("body").append(template);
		
		var numpad = new Blockly.Numpad(val,x,y);
		return numpad;
	}

	function position(x,y)
	{
		//console.log(x + "/" + y);
		var bodyWidth = $("body").width();
		$(".numpad_bg").css("width", bodyWidth);

		var nww = (bodyWidth - $(".numpad_wrap").width()) / 2;
		var w1 = $(".numpad_wrap").width();
		if((x+w1+45)<bodyWidth)
		{
			nww = x+30;
		}
		else
		{
			nww = x-w1-35;
		}
		$(".numpad_wrap").css("left", nww);

		var bodyHeight = $("body").height();		

		$(".numpad_bg").css("height", bodyHeight);

		var nwh = (bodyHeight - $(".numpad_wrap").height()) / 2;
		var h1 = $(".numpad_wrap").height();
		if((y+h1+20)<bodyHeight)
		{
			nwh = y+10;
		}
		else
		{
			nwh = y-h1+10;
		}
		$(".numpad_wrap").css("top", nwh);
	}

	Blockly.Numpad = Numpad;
	Blockly.Numpad.create = create;
