if(!window.DDBlockly)
	window.DDBlockly={};

DDBlockly.blocksEnabled_ = true;
/**
 * ACE editor fires change events even on programatically caused changes.
 * This property is used to signal times when a programatic change is made.
 */
DDBlockly.ignoreEditorChanges_ = true;

DDBlockly.editor = null;

DDBlockly.workspace = null;

DDBlockly.MAP= {};

DDBlockly.KEY = "ddblockly_tank";
DDBlockly.state=
{
	diff:'',
	level_num:1
};
DDBlockly.tank=
{
		pos:{x:0,y:0},
		angel:0
};

DDBlockly.blocks = [
	['tank_fire'],
	['tank_turn', 'tank_fire'],
	['tank_moveForward', 'tank_turn', 'tank_fire'],
	['tank_moveForward', 'tank_turn', 'tank_fire'],
	['tank_moveForward', 'tank_turn', 'tank_fire', 'tank_stop', 'controls_repeat'],
	['tank_moveForward', 'tank_turn', 'tank_fire', 'tank_stop', 'controls_repeat'],
	['tank_moveForward', 'tank_turn', 'tank_fire', 'tank_stop', 'controls_repeat'],
	['tank_moveForward', 'tank_turn', 'tank_fire', 'tank_stop', 'controls_repeat'],
	['tank_moveForward', 'tank_turn', 'tank_fire', 'tank_stop', 'controls_repeat'],
	['tank_moveForward', 'tank_turn', 'tank_fire', 'tank_stop', 'controls_repeat']
];

/*
当前正在执行的动画任务的PID
 */
DDBlockly.pidList = [];

DDBlockly.init = function(param)
{
    //inject Blockly
    var toolbox = document.getElementById('toolbox');
    //var toolbox = DDBlockly.getToolboxXML('intro',3);

		Game.initToolbox(DDBlockly);
		DDBlockly.initDialog();

   // DDBlockly.workspace = Blockly.inject(blocklyDiv,
    DDBlockly.workspace = Blockly.inject('workspce_block',
    {
  		grid: 
      {
    		spacing: 25,
    		length: 3,
    		colour: '#ccc',
    		snap: true
  		},
  		media: 'media/',
  		toolbox: toolbox,
  		trashcan: true,
  		zoom: 
      {
        controls: true, 
        wheel: false
      }
		});

		if (Game.LEVEL == 1) 
    {
			var defaultXml ='<xml>' +'  <block type="tank_fire" x="70" y="70"></block>' +'</xml>';
	    DDBlockly.setCode(defaultXml, false);
			DDBlockly.beginDialog();
		}
};

function btnEvent() 
{
  var btnRun = document.getElementById('playBtn');
  if(btnRun.textContent == MSG['play'])
  {
    DDBlockly.workspace.traceOn(true);
    DDBlockly.saveToLocalStorage(false);
    DDBlockly.reset();
    DDBlockly.execute();
    btnRun.textContent = MSG['reset'];
  }
  else
  {
    DDBlockly.workspace.traceOn(false);
    DDBlockly.reset();
    DDBlockly.game.resetLevel();
    btnRun.textContent = MSG['play'];
  }
};

/*
设置对话框图像
*/
DDBlockly.initDialog = function() 
{
	var dialogCodeImg = document.querySelector('#dialogCode img');
	var dialogTipImg = document.querySelector('#dialogTip img');
	var dialogWinImg = document.querySelector('#dialogWin img');
	var popoverImg = document.querySelector('#popover img');
	//console.log(dialogCodeImg);
	dialogCodeImg.src = 'img/dialog5.jpg';
	dialogTipImg.src = 'img/dialog6.jpg';
	dialogWinImg.src = 'img/dialog6.jpg';
	popoverImg.src = 'img/plane.png';
};

DDBlockly.beginDialog = function() 
{
	var dialogHeader = document.querySelector('#dialogTip h6');
	var dialogContent = '';
	dialogContent = DIALOG.tank[0].begin;
	if (Game.LEVEL == 10) {
		dialogContent = DIALOG.tank[9].win;
	}
	dialogHeader.textContent = dialogContent;
	Game.showDialog('dialogTip');
};

DDBlockly.successDialog = function() 
{
	var dialogP = document.querySelector('#dialogWin .dialog-p');
	var dialogContent = '';
	dialogContent = DIALOG.tank[Game.LEVEL - 1].win;
	dialogP.textContent = dialogContent;
	Game.showDialog('dialogWin');
};

DDBlockly.popover = function(content) 
{
	var popover = document.getElementById('popover');
	var popoverP = document.querySelector('#popover p');
	var popoverBtn = document.querySelector('#popover button');
	var isDisplay = false;
	popoverP.textContent = content;
	popover.style.display = 'block';
	popover.addEventListener('mouseenter', function(){isDisplay = true;});
	popover.addEventListener('mouseleave', function(){popover.style.display = 'none';});
	setTimeout(function() {if (!isDisplay) {popover.style.display = 'none';}}, 4000);
};

/*
将给定的代码设置为编辑器
 */
DDBlockly.setCode = function(code,isText) 
{
	console.log("DDBlockly.setCode:",code);
	if(!code)
  {
		return;
	}
  if (DDBlockly.editor && isText) 
  {
	  DDBlockly.editor['setValue'](code, -1);
  } else 
  {
    var xml = Blockly.Xml.textToDom(code);
    DDBlockly.workspace.clear();
    Blockly.Xml.domToWorkspace(DDBlockly.workspace, xml);
  }
};

DDBlockly.getCode = function(isText) 
{
  if (DDBlockly.editor && isText) 
  {
    var text = DDBlockly.editor['getValue']();
  } 
  else 
  {
    var xml = Blockly.Xml.workspaceToDom(DDBlockly.workspace);
    var text = Blockly.Xml.domToText(xml);
  }
  return text;
};

DDBlockly.loadFromLocalStorage = function(diff, level) 
{
  var xml;
  try 
  {
    xml = window.localStorage[DDBlockly.KEY + diff + level];
  } 
  catch(e) 
  {
  }
  return xml;
};

DDBlockly.saveToLocalStorage = function(isText) 
{
  if (typeof Blockly == undefined || !window.localStorage) 
  {
    return;
  }
  var name = DDBlockly.KEY + DDBlockly.state.diff + DDBlockly.state.level_num;
  var content = DDBlockly.getCode(isText);
  window.localStorage[name] = content;
};

/*
点击run按钮。启动程序
 */
DDBlockly.runButtonClick = function(e) 
{
  if (DDBlockly.eventSpam(e)) 
  {
    return;
  }
  var runButton = document.getElementById('playBtn');
  var resetButton = document.getElementById('resetBtn');

  if (!resetButton.style.minWidth) 
  {
    resetButton.style.minWidth = runButton.offsetWidth + 'px';
  }
  runButton.style.display = 'none';
  resetButton.style.display = 'inline';
  DDBlockly.workspace.traceOn(true);
  DDBlockly.saveToLocalStorage(false);
  DDBlockly.reset();
  DDBlockly.execute();
};

DDBlockly.reset = function(first) 
{
	  for (var x = 0; x < DDBlockly.pidList.length; x++) 
    {
	    window.clearTimeout(DDBlockly.pidList[x]);
	  }
	  DDBlockly.pidList = [];
};

DDBlockly.highlight = function(id) 
{
  if (id) 
  {
    var m = id.match(/^block_id_([^']+)$/);
    if (m) 
    {
      id = m[1];
    }
  }
  DDBlockly.workspace.highlightBlock(id);
};

/*
运行用户程序的结果
 */
DDBlockly.ResultType = 
{
  UNSET: 0,
  SUCCESS: 1,
  FAILURE: -1,
  TIMEOUT: 2,
  ERROR: -2
};

/*
注入JavaScript解释器。
 */
DDBlockly.initInterpreter = function(interpreter, scope) 
{
  var wrapper;

  wrapper = function(angle, id) {  DDBlockly.cmdMove(angel,id.toString());};
  interpreter.setProperty(scope, 'move',interpreter.createNativeFunction(wrapper));

  wrapper = function(id) {DDBlockly.cmdMoveForward(id.toString());};
  interpreter.setProperty(scope, 'moveForward',interpreter.createNativeFunction(wrapper));

  wrapper = function(id) {DDBlockly.cmdTurn(0, id.toString());};
  interpreter.setProperty(scope, 'turnLeft',interpreter.createNativeFunction(wrapper));

  wrapper = function(id) {DDBlockly.cmdTurn(1, id.toString());};
  interpreter.setProperty(scope, 'turnRight',interpreter.createNativeFunction(wrapper));

  wrapper = function(angel,id) {DDBlockly.cmdTurn2(angle.valueOf(), id.toString());};
  interpreter.setProperty(scope, 'turn2',interpreter.createNativeFunction(wrapper));

  wrapper = function(id) {DDBlockly.cmdFire(id.toString());};
  interpreter.setProperty(scope, 'fire',interpreter.createNativeFunction(wrapper));

  wrapper = function(id) {DDBlockly.cmdStop( id.toString());};
  interpreter.setProperty(scope, 'stop',interpreter.createNativeFunction(wrapper));

  wrapper = function() {return interpreter.createPrimitive(DDBlockly.tank.pos.x);};
  interpreter.setProperty(scope, 'getX',interpreter.createNativeFunction(wrapper));
  
  wrapper = function() {return interpreter.createPrimitive(DDBlockly.tank.pos.y);};
  interpreter.setProperty(scope, 'getY',interpreter.createNativeFunction(wrapper));
};

/*
执行用户的代码
 */
DDBlockly.execute = function() 
{
  if (!('Interpreter' in window)) 
  {
    setTimeout(DDBlockly.execute, 250);
    return;
  }

  DDBlockly.log = [];
  var code = Blockly.JavaScript.workspaceToCode(DDBlockly.workspace);
  var result = DDBlockly.ResultType.UNSET;
  var interpreter = new Interpreter(code, DDBlockly.initInterpreter);

  try 
  {
    var ticks = 100000;  // 100k ticks runs Bird for about 3 minutes.
    while (interpreter.step()) {
      if (ticks-- == 0) {
        throw Infinity;
      }
    }
    result = DDBlockly.ResultType.FAILURE;
  } 
  catch (e) 
  {
    if (e === Infinity) {
      result = DDBlockly.ResultType.TIMEOUT;
    } else if (e === true) {
      result = DDBlockly.ResultType.SUCCESS;
    } else if (e === false) {
      result = DDBlockly.ResultType.ERROR;
    } else {
      // Syntax error, can't happen.
      result = DDBlockly.ResultType.ERROR;
      window.alert(e);
    }
  }
  console.log("user code excute ok,result: " + result +";log:",DDBlockly.log);

  DDBlockly.highlight(null);
  DDBlockly.game.runProgram(DDBlockly.log);
};

/*
确定此事件是否不需要
*/
DDBlockly.eventSpam = function(e) 
{
  var touchMouseTime = 2000;
  if (e.type == 'click' && DDBlockly.eventSpam.previousType_ == 'touchend' && DDBlockly.eventSpam.previousDate_ + touchMouseTime > Date.now()) 
  {
    e.preventDefault();
    e.stopPropagation();
    return true;
  }
  // 用户不小心双击或双击
  var doubleClickTime = 400;
  if (DDBlockly.eventSpam.previousType_ == e.type && DDBlockly.eventSpam.previousDate_ + doubleClickTime > Date.now()) 
  {
    e.preventDefault();
    e.stopPropagation();
    return true;
  }
  DDBlockly.eventSpam.previousType_ = e.type;
  DDBlockly.eventSpam.previousDate_ = Date.now();
  return false;
};

DDBlockly.eventSpam.previousType_ = null;
DDBlockly.eventSpam.previousDate_ = 0;

DDBlockly.cmdMoveForward = function(id) 
{
  DDBlockly.log.push(['move', id]);
};

DDBlockly.cmdTurn = function(direction, id) 
{
	if (direction) 
  {
	    // Right turn
	    DDBlockly.log.push(['right', id]);
	} 
  else 
  {
	    // Left turn
		DDBlockly.log.push(['left', id]);
	}
};

DDBlockly.cmdMove = function(angel,id) 
{
  var angleRadians = goog.math.toRadians(angle);
  DDBlockly.tank.pos.x += Math.cos(angleRadians);
  DDBlockly.tank.pos.y += Math.sin(angleRadians);
  DDBlockly.tank.angle = angle;
  DDBlockly.log.push(['move2', DDBlockly.tank.pos.x, DDBlockly.tank.pos.y, DDBlockly.tank.angle, id]);
};

DDBlockly.cmdTurn2 = function(angle, id) 
{
  var angleRadians = goog.math.toRadians(angle);
  DDBlockly.tank.angle = angle;
  DDBlockly.log.push(['turn', DDBlockly.tank.angle, id]);
};

DDBlockly.cmdFire = function(id) 
{
  DDBlockly.log.push(['fire', id]);
};

DDBlockly.cmdStop = function(id) 
{
  DDBlockly.log.push(['wait', id]);
};

DDBlockly.retryBtnClick = function(e)
{
	console.log("retryBtnClick");
	// Prevent double-clicks or double-taps.
	  if (DDBlockly.eventSpam(e)) {
	    return;
	  }
	  var runButton = document.getElementById('playBtn');
	  runButton.style.display = 'inline';
	  document.getElementById('resetBtn').style.display = 'none';
	  DDBlockly.workspace.traceOn(false);
	  DDBlockly.reset();
	  //game reset
	DDBlockly.game.resetLevel();
}
