var MAX_DISTANCE = 100;
var remote_mode = '0';
var remote_mode_pre = '0';
var break_mode = '0';
var break_mode_pre = '0';
var link_stste = false;

var draggable = document.getElementById('draggable');
var container = document.getElementById('container');
var opts = {
    lines: 20, 					// The number of lines to draw
    angle: 0, 					// The length of each line
    lineWidth: 0.12, 			// The line thickness
    pointer: {
        length: 0.7, 			// The radius of the inner circle
        strokeWidth: 0.065, 	// The rotation offset
        color: '#288A2B' 		// Fill color
    },
	staticLabels: {
        font: "10px sans-serif",  // Specifies font
        labels: [0,10,20,30,40,50,60,70,80,90,100],  // Print labels at these values
        color: "#000000",  // Optional: Label text color
        fractionDigits: 0  // Optional: Numerical precision. 0=round off.
    },
    limitMax: false,   			// If true, the pointer will not go past the end of the gauge
    limitMin: false,
	colorStart: '#21CFC3',   	// Colors
    colorStop: '#DA1E09',    	// just experiment with them
    strokeColor: '#E0E0E0',   	// to see which ones work best for you
    generateGradient: true,
	highDpiSupport: true 
};
	
var target = document.getElementById('canvas-preview'); // your canvas element
var gauge = new Gauge(target).setOptions(opts); // create sexy gauge!
gauge.maxValue = 100; 			// set max gauge value
gauge.animationSpeed = 10; 		// set animation speed (32 is default value)
gauge.set(1); 					// set actual value

$.fn.gauge = function(opts) 
{
    this.each(function() 
	{
		var $this = $(this),
		data = $this.data();

		if (data.gauge) 
		{
			data.gauge.stop();
			delete data.gauge;
		}
		if (opts !== false) 
		{
			data.gauge = new Gauge(this).setOptions(opts);
		}
    });
    return this;
};

/*页面加载完成*/
document.onreadystatechange = completeLoading;
function completeLoading() 
{
	var lockAxis;
    if (document.readyState == "complete") 
	{    
		break_mode_pre = get_setting("break_mode");	
		break_mode = break_mode_pre;
		if(break_mode=='1')
		{
			checkfun(30,1);
		}
		else
		{
			checkfun(30,0);
		}
		
		remote_mode_pre = get_setting("remote_mode");	
		remote_mode = remote_mode_pre;		
		if(remote_mode=='1')
		{
			lockAxis="";
			checkfun(10,1);
			checkfun(20,0);
		}
		else if(remote_mode=='2')
		{
			lockAxis="x,y";
			checkfun(20,1);
			checkfun(10,0);
		}
		else
		{
			lockAxis="x,y";
			checkfun(10,0);
			checkfun(20,0);
		}
		
        Draggable.create(draggable,{
			bounds:"#container", // 边界
			inertia:true,		 // 惯性
			//type: "scroll", 
			lockAxis:lockAxis,		 // 
			throwProps:true,	 // 弹跳
			
			onDrag:function(e) 
			{ // 拖动
				var x = this.target._gsTransform.x;
				var y = this.target._gsTransform.y;
				var distance = Math.sqrt(x * x + y * y);
				var level = Math.round(distance*100/MAX_DISTANCE);	
				
				if(level>100) level = 100;
				if(link_stste)
				{
					gauge.set(level);  //remote_send();
				}
				
				if (distance > MAX_DISTANCE) 
				{
					//this.endDrag(e);
					//TweenMax.to(draggable, 1, {x:pre_x, y:pre_y, ease:Elastic.easeOut});
					//console.log(x + "'" + y);
				}
			},
			onDragEnd:function() 
			{  // 拖动完成
				TweenMax.to(draggable, 1, {x:0, y:0, ease:Elastic.easeOut});
				gauge.set(0);
			}
		});
    }
}
	


/*选项改变*/
function options_update()
{
	if(document.getElementById('omnidirectional').checked)
	{		
		if(remote_mode_pre=='2')
		{
			checkfun(20,0);
		}
		remote_mode = '1';		
	}	
	
	if(document.getElementById('four_wheel').checked)
	{	
		if(remote_mode_pre=='1')
		{
			checkfun(10,0);
		}			
		remote_mode = '2';
	}
	
	if(!document.getElementById('omnidirectional').checked && !document.getElementById('four_wheel').checked)
	{
		remote_mode = '0';
	}
	
	if(document.getElementById('gliding').checked)
	{		
		break_mode = '1';
	}
	else
	{
		break_mode = '0';		
	}
	
	if(break_mode_pre != break_mode)
	{
		break_mode_pre = break_mode;
		set_setting("break_mode",break_mode);
	}
	
	if(remote_mode_pre != remote_mode)
	{
		remote_mode_pre = remote_mode;
		set_setting("remote_mode",remote_mode);
		location.reload();
	}
	
	window.chrome.webview.hostObjects.callbackObj.get_remote_link();		// 调用C#
}

window.setInterval(options_update,500);

/*选中CheckBox*/
function checkfun(val, checked) 
{
    var checkNode = $("[name=dept][value="+val+"]")
    checked ? checkNode.lcs_on() : checkNode.lcs_off();
}

/*保存设置*/
function set_setting(name,val)
{
	if ('localStorage' in window) 
	{			
		window.localStorage.setItem("setting_" + name, val);
	}
}

/*获取设置*/
function get_setting(name)
{
	if ('localStorage' in window) 
	{			
		return window.localStorage.getItem("setting_" + name);
	}
}

/* 询问提示*/
function ask_yes_no(txt_title,txt_prompt,callobj)
{
	swal({
	  title: txt_title,
	  text: txt_prompt,
	  type: '',
	  showCancelButton: true,
	  confirmButtonColor: '#ffa85c',
	  cancelButtonColor: '#a4a4a4',
	  confirmButtonText: "确定",
	  cancelButtonText: "取消",
	}).then(function(isConfirm) {
	  if (isConfirm) 
	  {
		window.chrome.webview.hostObjects.callbackObj.call_ask_yes(callobj);		// 调用C#
	  }
	  else
	  {
		  window.chrome.webview.hostObjects.callbackObj.call_ask_no(callobj);		// 调用C#
	  }
	});
}


function back_main()
{
	var url = "../index.html";
	window.location.replace(url);
}