var base64_block_start ="data:image/png;base64,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";
var base64_app_music ="data:image/png;base64,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";

var base64_pp_picture ="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAMgAAADICAMAAACahl6sAAAAAXNSR0IB2cksfwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAZJQTFRFAAAA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEA9nEAopj6/AAAAIZ0Uk5TAAcPBAUuWh0DIpT/bRWDHySBGwEAOgkSX+JODW5bzMVMDr5QUrqtRgwKQ68+tbsst/W2GTTP8ysCGnmWJqXutC8G2OkgKKHy+6w2CBd22u+OIUcUceD5hyUwaSeSYveC7B6G5KhqZtN82/h1VuZz9uN7/hZNa8Yz1hBexD3ONTwxf0JAWaRxTUj1AAAEGUlEQVR4nO3c91vTUBTG8RBaWohFaSilslScRasFUYo4AHEg4ChDQaCyXKgI4kDc+n+bympopu25njy+359Pbu8HWm6e8IAkIYQQQgghhBAqaiWyJyq1c/j8ZZ4oELSBlFconmhPCBBeAcItQLgFCLcA4RYg3AKEW4BwCxBuAcItQLJVCn/oY76ZgiB79gp+Crevighid3GxCwMCCE2ASIDQBIgECE2ASIDQBIgECE2ASIDQBIgECE2ASIDQBIgkDKIGg8Fq2ykPQORIJFJjO8UfEq2NxWL76+zG+ENC9dpyZbLdGHtItKFRW67pwEGvQzY3eKjZ5nvCHSIfPrKxYFXY25Dt1zh67LiXISfiLVsrtsRPeBdScvLUzpKnTpZ4FuJP5K6Z8APyjyGnzyRz10y2nuYHafP7y20hZ9v1i55rPd/BDJLqTCQu2Eg6ui5e2rVq8vKVblaQts4eRemtuGr69dXy9V27nrfsjZv9txhBBgaHsjO379y1+POnmntJo4XNbh//AURND49sDI2O3feZTfm6xkaNFq54YHyaiId0pMd7t8cqJ0wkvolKk5UfGkuEQzpCk1M5c5X3Dd9dpV1mDu174jfCi4ao6Un94Fi50SfeYluaxOjHnWhIenxKPzh656oXIQPDvbsnbxvsKzCdsYAYXSEY0jY4kj/am3cyPpqZtXAYXSEYkuocMprNuxnsm7N0GN4+CoWYbHBkJqAb+3PuW7b7CsGQ0Hy78fDsdErNmdPfvDu5QiwkuvDYbDrzJBx0MmdyhVCIKtc+NR9/9jxQ6mRup+Q9/WNUURC1bvGF5cZebv7VeTASc+JQpiZDupNUEESta35ls7Pn4ey7vro7vuQIoiiT6dyPiSCIvGjnUJ69TmmDNfHMskPI1HhaOCRaa/2++lNmOiDV7V9y6tDOxeEBwZDQgqPP7+zMI7nMMUPRP0YVAVmZd/DzNNtc/5smN5DH8ysiISurJudgXj3T9W4citK+ui0RALG9c9ppqMWFIlv7/NbrkEOioYa3LnfnpsS7qBCIdk7XNxLsf7vG+lpZpYfYnudFKBYJkkMcnOeFtxTvrqaGODjPC285E68hhjg6zwtveSn7W3hKSMjlqfDXvV/8QAnZ+A25kLRXo4NE1yjPD32HmmUyyMTaR4Idm3Xk8HkqyLrzG5NiVLEOCCAkAQIIUYAAQhQggBAFCCBEAQIIUYD8P5B3M59ENviZChLuWi+sL2fdNED1XGs1UmhfbV59V6lvNJDvwYJzB1EbaCA/3G2jCP0EBBCaAAGEKEAAIQoQQIgCxBpy4aXoftFAOAUItwDhFiDcAoRbgHALEG4Bwi1AuAUItwDhFiDcAoRbgHALEG7ZQqJrc54obv3vXLOSPk9k+c9cEUIIIYQQMu435NbyBiy3WMMAAAAASUVORK5CYII=";
var base64_block_app_music1 ="data:image/png;base64,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";
var base64_block_app_music2 ="data:image/png;base64,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";
var base64_block_app_music3 ="data:image/png;base64,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";
var base64_block_app_music4 ="data:image/png;base64,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";
var base64_block_car_break ="data:image/png;base64,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" +
 "KkzRp6gatat914SCt67eaEuMe6cUYErLqgVblzxSvbv0+eeyPV7wVDOopFxYEhJAi2Y1nOH37EXakMFoZhSOjTjDF0ggwQZdsPIOuHRk1FUwdsdhU8qOCC+Buvb3OBa1Uw5XFy3LjFiYYhS1tEPuXPMNmnTTQPOd0AaPwRAQwCrb6uhY7VjJbymKgmSwwNTlR7S5Fi6jAVrOBC0bRkfQi68rq2FNHASLm8H+aBijv573/kjnof49OS8PKGTNH65+/e6VGf2hb64CSZvPwOuHW/4VNyUK8dmDmmwf05t6GqWOD7tik27w6JW22h0zeng2A1C6+S9/bnDYGquLH1ysDx2AlbNAowSr6vqhQDIEzNEgXB4KWpMeBEWp9rBHI+N7fRhJhJaPQO9vgoF3Q1JsJgGRJQSRk3hoYITSF2qKOGBGA0QpAreyD647/VKLPbLKT/r8PDjJiSynE37GApGMJQmi4ixICkZOC4Mx5kMmr733xbFda6/vcRpSrDN/zxXPPbBy2LStyqagxOShP4DrR/kRjSxCYLT4ktLiXwD+qbwcwMDis7u+ndeQllenFmfj06DhgLlVD33Yr2PJ1SF7McDqIEungyulTUJS2s8iNO5vPIXESCuioEGLcT7/bCk4EZtESpBBC2EQQgSkoHRSnf38eCsL+ABgS7PCd6Ic1cs/g8lohMBy8b4/Oa4cMiStCR4aKNxyz18mH3zrQY2+FyJuYFWfGV9wVz7y8sl4YN1+luNHAWSkKOpYI3wg1f2yKTGaDtpEs6/qZ4tmuwki0nuHI80Ac7bNXTao/LVfdxrMEJTl2st7quGUhkNWoBN8sBMfBFoRkNyQFXtFsSqlC0lQVOi8Aj5VueVY170CTkSiYbAKONHCoLyWQV5WCHyEgKwEkb0qkqQkIKhJgEOTjCFf3P7WkN2vP6wu2+40zAW0Zwzf77xt+TzbT/CYP8nQdb/PphsHRacU8xcumHDky+mfz/Qr+7JCp0FUTp6x+9l/jl7/hxf8og4RvRVk78HLEiKMBjzJwYswHEYdjO5y0B2noFOWPGdSa76EGEQk5AKhvAGJJVTtUrao0RrFKQoIuB2xlk5Fs0kadn8Q+sh+CKaT0CV2weuOhUxqYajXXChv/whok6AJR7jpX12zonTP27epZC99mnBtJrmOt+e9P2u2nRbO9NMXAeDZRBmP0duO9ryr1i+f9O70oBgPN7o7SHVA6fpnHpq1etZ3AsEmdZnzVGqI6JWhyCp/SIEkNWCDDhDuBlg5BqHGJjTtWArCMhJpBVMQbamA7HZDlCjwYOFpa0N/UcCAifNhEEOoTCWQfs0clJz0IJ2vAyELqtP6vqgbEEkazoRcSMG2/rcuu+L48EPLY5lQN3idQKc+wVG9cO14KaW45XySnoveUaN4OZv3FLrSZqz5dMKySW5SL6pbGIj4gCxAUmdd2cStj54sOvbRHI/OhhBniL0Dptd1YmGGRm3RUN7UQUR86Giohaizw2rJBf/uLYgeXAlf1AInnQr32jeQs+1NZBeVgKVkRBCBxmxBhCbAk/qzPJLqCRFIsKMhBIzY/+LTC1dfW27pqMtSl1J3q7ATaDHbHG2/3VGW0m9sFe1pPK9+jYvfkhQ32GZXFToKr9709YJto7p0iW61lQCna76GYMB09fqHl161dt4mse7AcJfJGNvSr/jJ722WlmMuFKxWG3su5WU7ZKy9qwd0ZacRQcYSEDlWABYike+PrmeMAb0Vbn0q+tSuvmLUO6UNw79+9kmb0tzX7W2FmLfdm9J//yf37++Xkta3mvN34XxfiXVJe7oUZyjJiqbVQhowZN8zT5zsuzlv5DG09XqliDYGZG7Njglj3pi0t+zrWz+R2k4U+IxpCOuMkGgqbqPOsXmEYkGQVI9HVvMx6hwvXJJjAboIBl6llmK3YUi4aszorbesnbz25m/zOmozVRqtu5MlHOtZ3DH4V59+OHvHcLcty2nBhXUKXeILGGPPqDAfqS4JbfaE9lW/2TDQ/MUjLwza84+H1OfUxqfJBNBRoGjXormZzKK5fYvGrduS/6tXT9lmrtTrMlQdozgtRKXyfr5vD4pjLlEcgpwefhjhExNhs/qM+SdeW3il66M7TZ492WiNV/C6vWyMQEeYI7Fmxl9uOzLywXfMzR1gQ52QOdsFPf6lA9j9LAQJWg7CSIson/D3h1u5khVDjj31XqqzOa9nb1zcNuokoKhy65SiY1unnMzs3+DRZawImAfudifadkRo7mS7vgAepWeMlhAidPBpbHDr9BA5hbpPhCR5VC1xGXPho32IgEG2+9CggpZVZYbyt6ZOde+7wuL1alTHZsGZTebx/XZH+47fuLPk8QXBnNIGcxhwh32QyfNl4/8LAMZAJFSSwB50ojNp/NZFE6ryRzX+7tHRFe88pevkWdXuaHr1xCgkq6MiC1LFnSDX3okTr2GgMf/EcW3fXcaN1ackf2WHnQwH87r2BoxNXFBidFIyX6+P1ldZ6S1vGkefPJw40V9dnCU0Dc1wHc8iwjJ6SAgGpzdedQPHK3mtxbHF/qc7T4345RcmQx0SXMfhNQ2NhTwX8cz/UQC7RZIpGP2N4DRm7B/20HN7xvz2zdIdf3lq4sFFC0mHSHe/akkdce8m9GgUuZ1VfXJR1QcnlkNigHQDMOrgQWDf6RKmqMSdu75BTu93AWl61S26pft9qyHAm2h17xv20LNHC655JXDCKia52qCjWhCh7Dh7GnR+8l8BEOq7HmjQ0RASvCdxKqmk69jMf/3mcNn9Txftf/fO0oold9hcDbHt4931XvJ7b1jRxD2c3Cs0iv9PnevVoYjnXNHYdSMU0K7P3F8z7TfvNY+8598+d8hPB9phCXaCtAiQLwG4bvmvAahKvKueEyNI9bbgoC3J6br8d3/0pF71R6710OSMhq/mFvqrrjCHWtPIiBTTmO7uA6oXQGd7zm6bJsSPON0v6lg4LRlV+4wTljVNuPNzrq3moLagCKxFA9OpWvhICQLxn3vs/y6AvYWQQUQlGLxuJMidKM+ZuL4a+vWdRgsVcrgGeKJt44aG94zIiLQP0Xcc7KOVeLb3i2aFcOzVMAR5GrwwQaEmociVqNWecoMtP6C9Yqc8YO42uzVYseNwC6ypJUhqPgA24oIyP/x/6hU4veT/HoCqxIM5kYA+6AETagBnosRWXfHh3WzpYXvaeNQl9iMPe06kmOuOJw/oOpgmCqTZFwywyVabscvnjkJwRzldQqjdPtnrZ3VtB6WU40PTTL7cqrewQ7sAfQwZ6CNvQ0KgERqltS3OPf4XsPuf/E/+J/+T/78FwP8Bv3M2Y4xt6uQAAAAASUVORK5CYII=";
var base64_block_car_move_back ="data:image/png;base64,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";
var base64_block_car_move_forward ="data:image/png;base64,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";
var base64_block_car_move_left ="data:image/png;base64,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";
var base64_block_car_move_right ="data:image/png;base64,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";
var base64_block_car_stop ="data:image/png;base64,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";
var base64_block_delay ="data:image/png;base64,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";
var base64_block_led0_color ="data:image/png;base64,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";
var base64_block_led0_flash1 ="data:image/png;base64,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";
var base64_block_led0_flash2 ="data:image/png;base64,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";
var base64_block_led0_flash3 ="data:image/png;base64,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";
var base64_block_led0_flash4 ="data:image/png;base64,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";
var base64_block_led1_color ="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAABQCAYAAACOEfKtAAAYn0lEQVR4nO2cC3RU13nvf+eceY80D0kjCQkJxEtgSTxsoBiIsYntxnESO6+bdCXcum6us9KkbpKmq/e2jp2kuUnatKuuV+9qksY3t47txHGedv2oeRi7xgKDDZIBgXgJEEJvad6Pc2ZO1z57JCSQxEgIkrUu31qzNDpzzp69//t7f98ertN1uk7X6Tpdp+t0na7T/5ekFLJo85FHpo+NqkLOhP174HwXlAVhdRk4NDBy4FShLwNH4uCYYBqmCTYnkKhhV+vf44iqbNn4ENQeJZu46GYF1CzENUj4QDXlNa8B+96BljPw326BBS7IGGBOfznK15+d8Lpt+kPNEuk58GpQXwmamEZu/LiaBk67wg9//TQ9fRuta999ZyWbEo3EMunxqxM4J6B2PswPQTp1zZbx2wMwC7gUSOcgnAP7RWxhMyGtu0klV45eU+OLONVdhmGcG72mKJDJgMMBpRWSc68hFQagUpCkT/CMCXYbOB1gtzMqOyPDiX8dadCzoF+kUAQHqqqKzRYDiiSoWhpNNTHV8d8jGHLpUigrhXBEjiOA1FRw2KU6EeNdBXAL5MD8yka+36bKSU35iAJOm+CiuQwM3Y7LcQBP+QGMjNSNYkgDcJvgzUHMBtqYBapCrykm4zWWiaKY4zZU18HngwULIJmUt4snVLEBQDh2K3rGj8JvCLghmZ5aB2ZzEnSnsyBkCgOw58QYYAChgYYN8GVBUSeekNMO0cQCdr7RTCxWzonTUF22knmVLURiF7haIw/oDLlDiO8NjVASgmgEbHZ5PeCHPf/5APsOf9/6f+e+F/GsuZdURieXm3gsMSchMYO9MDhc0NcXBqAzI/8KrhC6q+sEVAxBWxkk4xNzo9cNp87eY4FnLVSH5954gi9/agUhJyQNuRliTHcOuiLyHi0/lik4EBXTvDBH09TI5dRRAIRIikUHSvObqMprxUUwPFDKzje/P/rskY73c6y/DlVpv2SuZl4ixDoW1sLgEHSfu+S2mQNod+QBzHObJwc3K3DGD1VlYGYha47XYS4XuJy7ONV54drQwHJ27vsUyxc/RTgsF2/muc/jB1uxfC/GEZygqhmyWe/o86m0nayewTCkKOgGBIvAF4X4USl+gqP1Inhl1z+O57SSfpav7bGeuZgDheqoycLh45CKgs8J3QUhUyCAI8p35K9ih54MRFJQ64dKh+QY8yId1lj+Fh2nf8ThU380en3nO49Szc/wpXSSebAUYUFqIOGH4bjUsU5NqIc0c0LfYyj8ZevZpoYn2by5j1Rauj66CUYvqH1g5DnX54WTp1dyomPLGITgm+aD/Elr2AJwLIlNzHnhhw2wzw++ZGHITQvAiUgA5LDBSaEvHFBUdIkrh1OHphVf4njXFjJp+V3ZVBkHBx5m3Y1fRU/KBRg6xIRu6IOFndCmwD4F/Bo0Lvpz/MF3iA/Z+cDm/0fdjTDQC9HzEAlDyglpHxT5pPhHTXht9/fHzcNf3ULD/J/QcwzUMUtW8yJzLAuHhLVOSONzTQAkb1AUDSJJcLhBdUEkLo2CRWkIBcMsWfi/OHj4u6PPtXY8RNz2L+SMLpIpCJTAsmpwuKDOBmey0JuE2rng8kLAeAqP4JQ0vL4NyyB5U1LXEYS+Xhg+CR43RKL30Nu3dtw833PD/fxsMZxfKv+3AhVTRkP9A5AMwyoV3Nm8VbtWAI6QFTWkITIIK2qlPkxl8q6MAfeu+Xu6uv6MweG51hPZNKSjLssFEQvx2fLzNiGZDwEFN4VKIJKAPfulTiwNST8vmYFSNzg9kNVgoB/6hqTejSdKx81tZd1Pud39DkNtsChvdISomBqcRAJY7QXVD7np+7uzF4kId+Z4H5SUwZ1NkEjLhWoKFHth0+qPsW33r8lmgzQsfZgbG04SjkIuA4YJiRT43VCmQdAO9pwwIgqGUU0kCjaHuC+H399FMgE+l3TQB3UoL4MblkCoSLg1z7J138fpH3wfdvvbVNQ+wMEolt4UIiM2RxgREfIZQnLUmQUKsw6gAKrUD/+2FY60w5c+AYmMfAluLA3soaG+nlg8wNx5Zyxj4fZCz5AU/4BP6EwbO9J30BJ5D9Hkel7srsbIziFnQCYL2/8zh6p14XCeYdjfTNWcnZRWvkrcDuEk9PYLlRFlVdNdnOxYjkkr/UmI2CWnCvBEDB4S3kMRmPELevCaAijEzit2Trg1Iz6ZFWpBaTG8fhA8HvjsB6F/WAIorF8mEyGuR1AHoaMXblgHJUGIxmo4cOQBujq30B+dN2moIDgW6q1XT88dtLY/TKjkCKGyH1O/4F/R9T66o1ArDIrWynAUgl7pZ4osjJjq3CIICZHNzSgrczEVBuCIoyx2S3Ca0D29WR92LWKJUSaWB9EEV95nfPktef+nPiRjtmQfKG6Y64V5ORgQoqRotJ38G9rav0gy7Z7RCvoGl9I3+L/p7v0KVXO+TVXou6wqA80Fre0ynBOJBgFewAEVXpnAGOuaifUVecBmEzG7hmFkZxfAkTBLfJFTuBhd3+GJs/+DYPwki+oeoa7qRdz5YD03Zltf3AOLe6HeCzWDoNRCcROU9YDeezPPP/8jBvvrpwnZxDQ4HGRw+O8Y6LuH+uD9lJa0s2CuBK6qTho2cxjSCRgJbsR8PS4Z+x458QDdPV/EZnMSKP5zNsz5tcWl2fx63uydGJpC5mauv0m+ETuUztzGnv07xt2wuO4nrF/2TSKZwxw4Dqc6Lnx2P7A0L+LtTeC+E869uYWX9z5hhXNXg5zuGLev+wgVpVstXVu1UAKR6QcjATkb1PmhKwxtnbdxouOrdPfdNjqTYg9852NBPNowKTlH5XM/nnCiBerAkVhXEdb2Us1x7NQf0NH5CZYv+xYe59dRMEb1i5YHT3BCsQ/2Hvosu5q/d3WQy1M6WcRLr73CpjX3UFPzHNl8qCk4zeWW4t0fr2D3u9/h4In7LlGGaQMO2FUrBZeZmscKA3BZbf5uTcSbO4knvkHb8YetCGKEdF3l7daHqCq/hS9/+k40W5pEFoKvQDYMbhsc7bqXXWevLngjJFyVV/f8hg/611Fet8ey9r1doKRFbD+PV/fuIRaruOQ5hz3Ohpvux5cetOJix9SWpjAAR3SqGCseh2VLHqFu/i/Y3/ItznbdPe7ert5baO1ejG47yBIbvHez9Ne+17WAl7b/6tJ47yrT1tdfZmndfP77hjCPdsILlva5BxgPnlBPy+ofZ2XD18mmzhKJSNfpMkruMlnRSSiaAMXZyvtWfoCPb/gkgeCR0RtDwQ6WVp9mUQiKFHg3DfuB7QefnQl42wNF/OlfPsinn/gX+oKB6c81lQrw4s4fI6oAG1ywYhmsWd1sATZCfv9rNDXeyq23fIZg4KwV7YiY2MqKa1PGx4VxoKaNt65iV2JJKNFhYcUzUPELWg58gd5IgA+t+gFLOqPE3dBdCWeL4LU9n6Hz/I3TWfevFtXwyz/agn7fH3JX1RIOAW9882/58FBhic5xdOjoB/nnp25nc8M21m+C8+ZeSux3cKjjwyydu5v+2I+tVFgsLmsxo/lNURlUoNs76dCFARhLyJBHZFzSwl0x8slVU6aftCKDspJHSYiwzQmJAUjVQ+Vc0KMaRw797XTW+9Smm/m/r7zAnziCfDR/7fuRPsyLinHTol1D/8j/PN/E+1tgVzE8W7eNUHQbi6qgtw0yjE/HWaKrgnBxP9AGz10JgCJOTWVhWJcxqrBmI4UdKx2VFe6NrE+oaQiH4HQGQt3wzv4thCMl01lrR1Ul/+AIsnLMtRQmWmFe18Q03NPIc8pmmlw76BZo6TIDLiRpFDhFAicMkNA2hhNOR+F9ByYdtjAAbXknuXdYhkCCE4V5F4lP25iyj6rDgE1mqNPnIOyCY0c/M921umw2Hgc+BawbSdtfMZnweMkDrF67g1wE/MMQT8pQVGx8Ts1naUSk5cKSJsEkIojodVlbOBEVbkSUfAJVKFShK5JR6EzJ1LeovukZ8AuvvgQymoxBI4kaevo3THfp7zl0lNM/+Ae+9swPrYzTrFH65F1UDLmpyoLNDauWyuKXPwiL50MuBfEYeLz5EsVIxnzyCUzfCit5jhQp97ABQ1m5u9U1UDkHBsOQ1CFuwrmBTZNWwKagte+08txnv8IdO96gc1a4L0/xpI+egTUWl+XyjvUQUFoJpT4sh9vMp7sK/NqZp7OE2NoV2VGQ1qGsEtL5HKDqAMULQ7HVMx5fFPICfhxXMsCEpN1E4w2vMzAso6RzYRjuhIxTqqRp7tfs5APzTQj090BM5PecEHeIDHXtrIw/m3To6DwrLSYcZVFHqVskOXGGVGBZUwO3UKyaNBCj5UhF1iWESAtFHAzKVLuSz0IfPTnndw5AlRpLZwvdFyyVNR2h2/0+sKvj/V3VCX0GFOmTDlcYgEljHoeO/RUxvRrMzJhPHDgdPSxb8m28geNWq0ZMl8V2ry6C8uIrWetVIcP0MhQHlwfmVknR6Ry6lY5Tf4iq+jHNEbQUFE0lorQwGPo2dE+YOioMwF37X2JocNmkn/f0beYjH24kWBInJjLQYfD5od1ZcGLympHDbhL0ycSwHhFGr5HmPa+O47zx9FHuX1IF3Z+bOYBTgScoEp2PzeljydI4+/fB8XNQmhIGZeIs5G+TEoluBvpkgsPivu5VU4Anqa39jsk+KsyNaah/bMrPly38VzJd3bz5HKS6YEEpVItCkbuwBpNrSbW1p1m3HlYuh/pqWN/4IpVlByedgQhZ77r9O5N9XBgHNi79M0KlvyKWmouiZkZNfTbrIBg8T33NdhLnwJYvTJd4oMgt2iwO/84BWB48avXTxMOwKCgikQFOz1tNaehuMrobVZG6TrivLoeTTOooC+r3wLYJhysMQFFRC/h2otql1RoFMG95hWMqsrgiBBoyoDcMRRkoKm6etYXPBokU1rGTzbybz75tXgEr54uacRqv55domQvdYbl8vUQEBNHopF9emAgLl0UkC0TwLfrxRl+6dJ5FMkE0j2dVOcmgBzw20VnQjNv9u6EHhWvlcrQST3RYSeFoDN5uk92xIl0nmMS46CVcs2x2ylh8ZgnVcRNTpQcfExkbRTY6enxg80BVtcHi+RO3t19rEkxQVvok5SGoKIfqOeDwyXnblRm3/84gEhFxZDYfL4r3usxoDGZh/27YvBbWLoehCPiKYM3yx2ht+/xvHUAVgzVrHscXkHMXSZGzZ2U7ipAaMy1DUuFg2wrnq2lkY/K7mEpJnVfklRGK8J4tt8Arw6NXd4vOVCh2QCICKxa1s6L+NzNc9uzRmrX/xMrVgwQrIFgCb++FA2/DiR5Qi2FxLSyeI3WgyBGmJ48+xlLhDZYpXeqL8gDUVstm7ZPHQSmSnwsuFG29Xg+cPCd1pqDBGNQvfpDWY/eMtoEUSCmXk/L8rT5vEamZZmbsWoybb3rY4iyPKltE+rrlyQG3QxaPAsUQcMo0lhaCgYgE0rj4+MB4KtCIIJt/GudDQx0EiqTSNcf0KY8ALQJzISInu+BsGFq6IK6eYVn9l6a97nCER4EfYPLv6SjlM81Ib1hzH7G+BM1bIXZaeg+i73Bk3kq+h1s0QonayMK5cMsqWL4IXHZpSCahwjiwukz0O8vwR1jfsbAL0MSRAI/VJrYQTe3F4YxaIZ3QLU3zZJFm+aZHMTO30XbiQ4Wu+wuPP8nLzbtJmCb3pzPc1tkzLdwsalj2f6io/YW1mSIiqy6H81Zj/Bw0Tcfl7CerXGg0F39FDUg0a86fAyXFTNWFVBgHCsWaNaReGBlrpClHHCdIJJfQevhJEonjnOs5Sji6AX+xBFt0lS4sg9oQvHf9vfiKdxe69kAsziffauH+va3c3XpEuhXTocrQ86xY+gXCcagIQE0IC6x32+7jXNcxevqOcfb811A1J75iqf9y5oU6jwBSMId9cs4vrDfmwfvG/gd2kdrS4dgRJ/2Rv6Kt/SHSmQubsXReM3/9x+ut9jKrrUKRxxo6hFj3uGg5so3u3mmn+qdF86p/zrJFH7d6EGPC0HVLCdJsAfYdGGJsA5bff5yNNz5CZenTdA9AqUjLBcZtmPLPE/fGFMaBQmeMfQmOPHX6k7zVcoQDBx8eB541qq2Lzn7oHoLzg9A7KHOGwrDksik23ryRJQufvGrgrWp4jFUNH7f6r4Xh8znA55ZiGSjK4nKODy3C4UW88OpTbG3eimE04S+SKmvsaxIqTAcWhy689/uheff9vLxdFM4upflzX6as/E/59S6pkEVJtLYSfr9cirxotS3OQeMNW6gt38Gb+/+JRGp28oZe13k2Nn6OoprfkByWHCTUyOJqqYsFmC5HFM12F2++/QRDwwvGPX/m3O109RyguOhGgukW2RY8NRUGYNmYNpKKSjjx7Ccvuaei9DgrljyCz/80fRFpvaxzvIp8P3rGRLkQEjYt+BEV5c1s372D7p4ry14X+bvY617HL21n+VkMKnOMltQEcMLtEueUE0moCO1i83ubONT6FU6cegjduJDTNwyVF7bfSUmwpRCdWxiAXWOyUvEo1NU8zqHDMkfmdqWpX/wtbm74FsWKwd7TUu/Z8qeaBBeKDvvyUvCdl+Ig6sqiUVz4Y27PEX7vpg/x/MvN5HIzbDnWerl77Vrq+88xlAGvIg2e8OGyFx2wFhsoQMwqCebO+QZLFv+UM2e/SuvBT8sEgsfg/be/YnWsZsYA+PQvrgDASN+F94lBIZLPsO6mYXp66qmqfIGamhPWLg8nLzVLHieWMfn3ncKAyOMIAzGszvtELN/Jr2VQlOkd0Bj3HS6NhYEuvlEBHh02GBAXeqtE6l6bSAyMySIJEMUmiz6b0Jx27ty0Ba/j3+gdWEdZ+fOs2dhioT7O/7sSAG1jiouCm0TqqizwH+ip/7B8PQGGO58mH0tioqIYdewEbO2U4iy8/9yZ/CLMfDhICdnszAvAhu4nNyeIGhi0iuN+cf5GvXBmWTS5R4e5JBKydHJKnj3x+bZhmtusZ0T6SmSsp3CgR6GZ0YTN/KQyl0n3iM90BW5eD5sccgEX+6Q2q31sP8/8PEk0NrNGc6X2NQ57BknFLj1IOEK1osFcxLiTzFXoZOEl2LULaywgQ3N1j/wLHSTaJBpXSc4zJlDKggu83jCnT/8xW199evpfosK31S/T9CKkkhNvpsD0xEJoWwDe+MzWMgldPQAFMNau6tDeLhc36SxsohXuJ6xekWZ/yxfJsirvo07GAuKzDEHfG2gLv87m/a0sv8x8dkTh1UZYNL3TmJejqwOg4AKhWxxO2m57L+mKOdiSF/9UyRjK5Ui6XEQ/ePcvQyeOvWTGkstIpWyoyqXyaMWsqobDkc6GSg8MucqoOLMLZYqVGKoNV9TPksohMK6gx3ACujoAWgF5jIMf/QTN934E9+AAylT6RFFQslmfamR/fu49mxegqWFUNTch/420kZg5O+mM12HqT3VHP/81c//k45uKSjIE+o0v0/D2m7PULifp6gCYSmEESzjSsBxP51lcicRlT1UpiuKz2Wx3uKcS9UufEa+P5XKnvpb/XY+J77OOLjs4OreRuo5TeAZOCXei8PVMQbMPoNB9586hPfBZbr71VlRdv2zGwjTFD3Eone3t7XVdXV1rPMKZvfxJNi2bzeq5XG6bw+GwxpiKXHqGwUAp3aEqFrQcBFtwVpY7+wAOD2M2NLHv7ntwDA1hE7rwMiIjOMkwDFs0Gl3rcDhuyF++LNNagpzLdeVyuX25y/QhipvdsQiH5tVTFTiAqz887Va2iWj2AdQzvL1+I++kM/j37i34QKSiKFVOp/MZm812WW4aIU3TxOszuVyuRilAr7n0NP2llRxdvZ4VLzx/DU9rFkJiAeI3qwJ+nkclsmM7XlEzLmBhuq7j8Xi6li9f/nlVVZcZhuUwXlaETdMKLV4qBDzkr/bgTcToaGhkxY4d8kfRrtCgzB6AQoRSaQ6t3kioaTm1kWHUAicnxE/TNENRlJ/kcrlNiqIkCgBwpL19a6EAYhkTnaTHw9GbbqK+/XBB4drlJjE7FI3QuWoVu5p+nzmKji0YnNa5JCHCqqqeK1R8yRsf0zTfstlsv1foc6pp4opGab7rbhwDfdQdOgSV0zqFMY5mD8BslrMLl2CqCrl4nPQ0uCJvhVNOp7MVWDD6Y2OT3Ct0n8/nIxqNxg3D2KNPs1aiGAb2SITW9RuZe74b+xUc4Lny1o7RWSnYslls+WJT3kcr+KWq6mAymVyhKEo18AeTcZQAL5PJ8O67725yuVxVFRUVD8bjcWHFC37p2SxKLEIqZ5Jze2SnxQxp9gCk8AzGZCR0oaIoEZfL9VNFUf7ONE3RHidaqQ7lX0cFl4bD4b947LHHXk8mkxG32z3tzbJ0pqphMwwRAc1qZHKdrtN1uk7X6ToVRsB/AWnw3OQCO4MvAAAAAElFTkSuQmCC";
var base64_block_led2_color ="data:image/png;base64,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";
var base64_block_motor_a_positive ="data:image/png;base64,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";
var base64_block_motor_a_reverse ="data:image/png;base64,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";
var base64_block_motor_a_stop ="data:image/png;base64,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";
var base64_block_motor_b_positive ="data:image/png;base64,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";
var base64_block_motor_b_reverse ="data:image/png;base64,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";
var base64_block_motor_b_stop ="data:image/png;base64,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";
var base64_block_repeat ="data:image/png;base64,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";
var base64_block_step_a_positive ="data:image/png;base64,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";
var base64_block_step_a_reverse ="data:image/png;base64,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";
var base64_block_step_b_positive ="data:image/png;base64,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";
var base64_block_step_b_reverse ="data:image/png;base64,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";
var base64_block_step_back ="data:image/png;base64,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";
var base64_block_step_forward ="data:image/png;base64,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";
var base64_block_step_mode0 ="data:image/png;base64,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";
var base64_block_step_mode1 ="data:image/png;base64,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";
var base64_block_step_turn1 ="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAABQCAYAAACOEfKtAAAUs0lEQVR4nO2dCXBdV3nHf/e+/T09bc+yLVmyY9mOtyjETmKDp1mIU8LmLCzTQgGTUIoLJZSdQlsIAw0E0pKwhZQkhFBmWhIwMQmZSQMpBLAdx/EqK3YsWZYs25Ks5e3rvZ17zrlPV0+SLS+Snmf4Zq6f3nLPOfd//t9yvvPda/4sf5YZFc3ZufkG6x9gIRC3PwTyQBAIAIOAX30XA44As4EosABwAQUgAZwEGoBK9T6izrG+9wA54DhQxSep4yYMMiTRiHM3s/hDsf/JiKYOa9xZNc5m1ZfdRghoU6/1QFKNwzpHV+dYY/Sp9zl17dro/rWfjfztnrHZsy7KYA0LeBidlWKwppqoMG8hzY3oPDfp9gx10dMs09+lKWa0Co0fE2QbGivFxaNmuqAYpLN+Uu3ZzDPOgq0XUKaPgaY63NwBfBuN4KiLdqqJJgAcPG17hgNwHEBOs0wfgG4uI8V/oXN5kXFpwOtLCZuTzQQEAJKhKTw8MaYN6/uMsqd+NXpbdWcAPKYcQMkuLxr34WOTsnvysNS0qqqVeau+Ts/Or1LINAoHFAb6eYhf0C7e2+CYygFVAUuA+aLlEeBmQH2ZMhtoAzWXd+PnJIYCD8U667vK2vtZ/7crCfl1TkUbxVS6BMPydPEt8VtbLXPKUzYCa4GVioG5KRn9WcmFZ6C0c4sJ8zAhrhEXadsp67Um8hJVs9/HJStbqamO8PRvvylCCdRoCjxAO4eFN7beDytgrwZeo8CPz5zNK5ULC6CGB52vovFpxSZ5wXnxGmPx2o+wbNljGLNg6Tr4zX0fZjgTEWqpCaBS/IlvivjMpc61YrlVSnWjSvVdF3TU5yXnD6DtDWvZgJv/BOYUPW5W/aZ5+cNkVnyMZDZOyAOhyyCejXBg68dEcI4yJgkeIkqnYJgV7C4HlilbZ/vkMmCdU84dQNumhWkiwiMEWC/sG4pxlupGavZQd8nt1C/dSbsL9Bxcdh3EM/DE3R9nOBuhVv1+Nnn+l2/RrWzclWJSYAhIlR9wtpwfgAG+yGK+JFiYdrDOr6VpuvrTNFzxHbIHYbAPIksg5INEAjrbIxw7+CFh56xzKoC9fIcTHOYaxTxTeOOysXUTyeQB1BzhhMmNaDyMiybhGArqO8sZVCz8b5ou20S4boicDulhyIbg2suhPgKJHOx+4SP0pWdRV2xvgBxf41LgcrVGzZ0GOM2hAebMgnxmAO2ByUV5HS4exOTW4ne2ncPXTrBpI0vWvUBeh1Q/aBHw+KCgw7ZfgaFBIVtHx447qXGAkCDBYv4ND9XCUZhjALFD6CgaA5giTdEDdKLRDvSNAnQaY8IzA2gUMyyfJMU9uNFHrVlDboOFLZ+hN3Av/YOgJREAui2b54JkBo4fhkJOvi8YN1DIRUSb9oXqNJHmDmHrziROYE1xrjWKw8A+4CXcbCXPNsyiRZ5SmQwDX4uHH4v4316C2aFEZM5TLF39AeY0nKR7F+SzDvqY8s9cAcJ1oLtB00EzDnI0AdHs+L2bqm17lWE4AnOfigENtWKRyzivsJoayzF5pwiwvQzg53eYbEHjSUz6p4qVEwNoUo2LB9D5qyImBeUx/VoXi2/6ALMWP0u6DVIxMI2S89X7ilmI0EV8ZoJuvsyi17SQcV9NPp9AK7k0t88kesJF97Yqckkf/ooU7qCO7qtloGsOixobMc0mThxaCOZscU5GgexR4OvUEuJW8twq2nfxKwweAJ6+0ECOBVCqxSZc3CsyJjichKWWDYu/QkXNvxCokWqZm0hTlK4ZecgboGkSwHwSrnj9PoJL9xEfGmv8fRVwvBVOtYJuQCgM/jrwVcOxNli3EQIhePKeAJeuaebV7Stxe68kn3kt0VNrSGT8Yrw+xWLZwwZ0NmDQQRXfwMMPKCh9Ok9ARwNYQwN5NpPhapVSkpkP6+9A+Dc0vfF2IoGjDO+GTAK8IQnM2Yhm2cUo5I5DKj4WwGwCUkNQyINhyEnKp6VrFomIHGST4HKnqGnYj+7eT33z/1B1GSR7q9DT19LbuoG+7puJJeaopaW8lgwLmcv3KHAXOT6NyaOl831+AAZ5XKw6s8UOLVBf4U23fI7dwc2cMKAmKS/Ao4PpkgB6PFJlLSeQ06Stc7ulTqUsp6J+ZwFiZsDnB1/lyCrGKRYDPX4wC2Bk5at1rsut7J8B3iCkE3ISjQKkoxDKWhM6TN2CLSxu2sLh1Ca6976J2IEPEY9tIGVIFZdRQx06P8LHnWi8B4MDFwbAPPPEq24nADxpll/z1/gv2YV5AAJuGaPVLYZMGjwDkDSh4wg0RGCtVzKlT0N45OoUrFoLhinV1+WCdBIO7oLCPglOqVjOJh0Hbw24w+DyQjoPqR64cQN4vXDkZahbaNlLaSIsgIUDy0KhALkB0KsMKhufwmc8RZ02j8zgpzhx+B9IF9wCSJkmW41OKz4+i8k956LOpTbwEDrzi6GLK+dn57bnONTzBRpqH2BOM8ROwLx5cKobXAnIm9DbB5cuh1UeaFXpl8QQVBbgkhslSwRzfBCPwa6dkByWzC0Vi8kWMN6wMg8aZIcgOwCvezs8/ygcfAnWvAMGj0NjC2SHwR+CnCH7stCx1D6XlCahovYY89Z8nNnLv0znjrvpO/YhuWJSRAnwdWA9GhvQRiLbycjofKDBLWR5clRkX0jU0t/2fTp3tzLUvYpgWJ5mWk7BLX/n80K2AMmU+twFLo+04skEJJPysJZxlkr7gxCsBn/l2CNQDZ4AmHlp70zFMN0D0T45sGCVnADrCNXIyKCmEhYshYEeK1gH3ZFttdiZilqqP0j9yk285k3LmRXZISJFWwlM3kATB/GyGONcASyQIMUtwK2Y9AoWetRMxRPLOfr8Tnp2PEQqEcIXloHxRLzXVCyo69J+WeprHbomwXUHwO2fxBGQjLTaCM8CX1CZA7dU72LsadnCGLy4GVIRqL8EUr2SkdbvrfHkMtJeVkXauPL9V9O8+oviGnPF5eACNPags2ay6jxahUfWu7/EYAt57sHFJwXMXhW49nXdwdaed9Kw7E6WtfxIGHRzSA5yIhEBtClfhU2LXk9scB0eb+yMgYSma+RSUEhGeeVP/QyePIk30I6mDYi+A5UQPSkZaqm/NUk5L/gsD1+AulXS4xtJKHhlFGB5eXcdzLryy/QnXsQ4+LSw5SFBqQAmvweuwWT7ODQ7DYCjwbRSoJ8ixA/w8Sgmr5PhjGWrC2E69j9C/MQmahfdQSDcitu2ZwoPy0GEamHHi9CxFyqqJIBGfh3H9v+WbG7yiVHbnDz1IHh18HsT7OttJ1i9i2D1VjT3s5jmIQGoNUEeKxJwS1NS2QAD/XIn3TwF8T6orpMePj0Ew+FfU9VyHYEDzxPLaSJ+tOii8ww6V5DnqDARE8jp90QkIw9RYB3wLpGd01WQaql136m1vLp9P/2H7wPNJy7AAsmxhymSCQNd0LUPju+HnlfqhW3z2o7qDIeuzIjHrhgwrAggRGy4heOd7+XQ7u9y5KWDvPDIHvY88wl8gRo8IclEsZzMIAJ2cwW84xsQrITBY9K0WGp9IgnL6n7HhpabiOkUwTKoIcDjpNFEWi2nUnYl64ZRHPhSi1qqedUHGfW3dPn7MPg2WZHmvFqcafM3mVxLf/smNHc7wcYDpDUYHoJgEJrqwTUHwq+F6qugYkk38cPvJZetdEzfEUy+X0wIwA7gRfG3Ths5uskTxy2mLVBMnXkdYxiIzqGn8yZyMcvkRMC1lYKZJhiBWBfka+GW98ANH4SeVjjSKuacw33QnIerLm2nq/YYA503i7YleeYRoppXeIadqlSlG+5yJD1G18a8SyFcoQg0rFLrTia0ArO4nLk8Qo7VxWA4oxb682t/T8PqjSQSHURqoaFehhlHGiFeBY1eOPbTT9C5795ijY3VU54VuESKarRVtMZyQAXAVxAkziJMsbdsmZQb8bNU/C7ruBrLsvpcOZqv+ABL3vgYR34D2lXw+fsl6BYrN38Ptv4SukxY7YLV9dA2B9qeeJATRz8oTJV1bdXAH/kLdvEHUeNjdTN0bgyUs90vCnBO0seDJDjGLNZjCJsh7eNwagFDRz9GLuZn3ornqJsjbc+uPTJArm0ET2QfyV0byRhhNQI/GjUUROZE9mez06v6LAgzliNDLzp7yfI0J/gOQzyOhzgBkY4NifN9InHhov/4bWRPLsQd3Ix/Jax7vbxiyz4ufx0keiHQBYG50GXZbMNaZz/H8UPvFirsUoRqZAGr+LHoYTnctWsEs3PbF7b3ag1+SA/1DPKTIu0DKoEwNPg59v66hwPb30ygDkLVYB6FbDd462NErrwP50LExR2kaREJ1ZgjZTbRCO2pH2Y/UT6LxmyS/D06/eIctwKy8+BG2re+CCerx7R162eg+a0QC4BvHqSroGZdkuW3/mtxz1leq7Xfc5sgVGb8YQg5IwNdIvcrtxiTaoApshj8ggBPo3MtLmYVWRDLhDna+TcUBtcQ9T5PuDJGxQAM10Jo9stkX9xIkkoHUG7ibBH9ppQKWRMyUGSgHJPm2B/OqNxgSCQ+dqBzL3nm4uEq0aJHtNVAtnUDNfMfpfd4jle3w5HdcKoLCm7IWrGpH7wVcvkYqtzDye3rSecXFBHSqMbDT6yJcTLw7GygV9nAJqVWAXWhXlGFAF0CuDtZwL+TwVW0SwJsDeYu/TzeOXfTsgCMZfDsz/+RxI7/EP0ZKnRK0oIpelEb8aoG0Wpjtdob1h21hVGxkSrrEIfVd2kxyR/F5P6iObDON71PMnfpLWTVKscKrMNV8L4vwILLIBGXK5/6FfDMA7fxgy/8nNkOpExWWBZZe+xCMdCjfu9SF9ojrNk24LsMs4gwKwQwdog43L+ewa730bJoF0fdnVQu3oOv7XZOpcLKm1pxWBAPvxT9+orlHnKyKhwFj04GVigWZhy2uprtYqPf4NpiltsoLCXS1MPiN++kph5mLwH/bNCtpMQxOPoyDHRCbxtEu9vo2v4u8sySdlP0fYQUf7zrwAhmF742xiOYcIoo70DnBlx0FCs+xWQYzWx+4v/Y/b3HubwpyaKbPzxq+W5yOylahB2MK/UNqwkaVsCNJ4YjXrRySi2i0vaf8fPsqE2qgdZPEVoIs26GmtdDw1vgWDX0V8LidVC/GsKXwPUfhbXv3DyqyM7FDaVprwvHwCr1XUipf06EO0cY5j6GKFDF9bhU9yJhUlhB228/SCHfhiu+jEy22uF9PSTEUnKkkss24FnFTJSzsRlYqzRgQB3t6ohygDB/Vxx/Oh+hEG+lkGxlcC9ED0H0VTlgLQf9J2B4AIb64USHQc++jUU8NMJ4+eFdu0dcydSWt9nq18tXCPIwiIKjm9RgIJueR9feb+LXjKIuGKoIs5L7KbB3TKLTLKrTSLzoVhPdrkD0qUmSqaod3MivCPNWMRaRbTt8G83zfybCKtGelQY7Aq8eHWnfSpQEgtupqz7G8NA8GT8yF5coNtk2PQDaIgu5e+jljSzjzXj4IQXqxedmQSevtkpHQLL22t4q6hXGE03VUnscTqpbObdFJVWvWeGdHyMo2pNADw2updflwV2fE6kva/vAF4IVS8BIyJSctcwLVMbp+EMrvQpAaZ4WTT+AOLLcJk9j0EiOr+Dhn0ZVGTCyhMYkOF6FfPE3YcVwn2JjVF1gaVu6+P73FMSmvAyZUvFm4tql1DTtx1A7+XotPL8Fjr0A/lo1Zis7Ht1DiL8U7/1iK3++cyjTW6Vvb1QZGOT5PDoPicPPdcWCpIBgVAaNLcXl1HiSU6HTHMWqicBG4HMcg90iRWVvz3qPz6XCt1+osfhNF8yrg8a3jZwXqoKO3R3s/qMcV1w4qDpn0zNzm4NWdEqHiXI9nbybBt6OD5M4cTr5GrW0iaVT4jTt+JX6picVT3QIAG1JDEcY7odMUn6QHoRL3wZN10HqlPysej4kHzpBTgEoY0y/s9GZu08Ex5q3i5/i4qfCuryqZrrOkRWb6NxU8ZaIyYhMVBSjiQ4vsV5p/4Tkoc8qwPgFxZyWtS2QH4yLJMJIhs7r7GtmAXSK5jjOlE63f5M/qwr9+Kh23T5DbA/k1aLXyh/GBiHZrXKJSnR3RthCC2hpU0eFfuUD4NmIncwYW8V17iLKTtxyj0ZXlBYZ9EK6uP0q7eeo6b04ATRGtOws5MxQm4zd7DcdBsJ5Y4+Siw9ArVi0fuGLKrWSFFpp+851vZIZuD3vPMRp+6aq/fEO5/clYdXFxcCpZB8OT1sajDv/LqHcxQXgudm+yYuTfUxQe13y/uIBcKrZxyQYOM77i8MGTrXtOxu5aAEsTDH7mIQT0S/WMGaqbZ8tZomXLfW64ziR8mfgdLHP2d9EDDRLc/gXAwOn2/adzoloY8dS3gycbvZNRi6aOHAmPK/mSLExwaRdNF64HNnHWADLk4EzFfdNJpAukfIFcKpXHRP1e6alXImUH4AFtbHkmyEGni4OHEfKzwam1U7b7LGlZNMip4sDx5HyAjCvnvTmdhQKlbmUjwrby7VF6v3pbvkvIykfBrpUuYZxhk3yMpOZAdAODQzlNOaoI39mo11uMr0qbHs5lyPWq1QOw1B27+LapZkmAG2muR031fgcapodP1U0rSJuaNRPHweOs+k/9QDawNSqIkzXqDsky0PsxxHk7LhJG7n3r3RVMi3pLLvTggKtRlVQmWXmXU37RkgNYkOy0Mil7sae6FEGU8JA545+xvGE3JxjIzo7ucB0WsVSWesOzyJ46pGY1nMarJsWtXF0tkTOD0B74W0veRY4QAqVsK3cMiq6VsI8Gwp1MYWMrJMpZeIFY6ANWoOjUV+JmpZrLCfG5kqRiFnPbpU3dI8RUz3TQc+M8h7ntS9sPz0op55half0F0qC33IPgi2nFu2/GTSvuJcgP0HWwrqp2zCuHOVQJpWRNkvAcDkY1+ywd26HRy2jp0qOETl2fZT6JYbej8b7J33+CB6TqA90pnHUQzCKnefLKPyYrEjmpEdd+rlMuEs4w1GPSBsfQLt81lSvk3mqWjmLIUzN/YSpIi/+p4DYWY9WJ0iaATq4+yJHo4wE+H/U/GuLJY/bFAAAAABJRU5ErkJggg==";
var base64_block_step_turn2 ="data:image/png;base64,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";
var base64_block_step_turn3 ="data:image/png;base64,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";

var base64_block_step_turn4 ="data:image/png;base64,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";
var base64_block_wait ="data:image/png;base64,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";
var base64_block_wait1 ="data:image/png;base64,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";
var base64_block_wait2 ="data:image/png;base64,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";
var base64_block_wait3 ="data:image/png;base64,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";
var base64_block_wait4 ="data:image/png;base64,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";

var base64_block_app_picture1 ="data:image/png;base64,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";
var base64_block_app_picture2 ="data:image/png;base64,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";
var base64_block_app_picture3 ="data:image/png;base64,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";
var base64_block_app_picture4 ="data:image/png;base64,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";
